# Parallelizing Model-based Reinforcement Learning Over the Sequence Length

## How to run

* Training
  Before Training, please set up your wandb logger by changing
  ```
  os.environ["WANDB_API_KEY"] = [Your API Key]
  ```

  Then, after install the dependencies, you can run your experiment by:
  ```
  # Atari
  cd pwm_atari/
  python -u -O train.py \
    -n "[your task]-life_done-pwm-100k" \
    -seed [your seed] \
    -config_path [your config path] \
    -env_name "ALE/[your task]-v5" \
    -device [your device]

  # DMC
  cd pwm_dmc/
  python -u -O train.py \
    -n "[your task]-pwm" \
    -config_path [your config path] \
    -obs_type ["visual" or "proprio"] \
    -env_name [your task] \
    -device [your device] \
    -seed [your seed]
  ```

* Evaluation
  ```
  # Atari
  python -u -O eval.py \
    -env_name "ALE/[your task]-v5" \
    -run_name "[your task]-life_done-pwm-100k" \
    -config_path [your config path] \
    -device [your device] \
    -seed [your seed]
  
  # DMC
  python -u -O eval.py \
    -n "[your task]-["visual" or "proprio"]-pwm" \
    -config_path [your config path] \
    -obs_type ["visual" or "proprio"] \
    -env_name [your task] \
    -device [your device] \
    -seed [your seed]
  ```
